#-----------------------------------------------------------------------------
# Cutlist Tag Definition
#-----------------------------------------------------------------------------

# This file can add info to Parts & Assemblies.
# The general syntax is as follows:

# PartID 	 		Description				Expression
# :AssemblyID	(Maximun of 255 numbers) Description

# The "Description" is usually a short name identifying a part or an assembly
# The "Expression" is a typical Compose expression with the following syntax:

#										VarName=Expression
#	VarName can be one of the following:

#	W	 or Width
#	H	 or Height
#	D	 or Depth
#	GQ	 or GenQuantity
#	VGC1 or VGenColor1
#	PR99 or PRice99

#				<Kind>					Expression
#				<Grain>					Expression

# If one of the dimensional variables "Width", "Height" or "Depth" evaluates to 0
# the part is effectifely excluded from the part list.

# The tokens <Kind> & <Grain> can have expressions which must evaluate to a number.
#		<Kind>		0 = Make, 1 = Buy, 2, 3 = Draw, 4 = Hardware, 5 = Prompt
#					6 = NoOptimise, 7 = Plus
#		<Grain>		0 = None, 1 = Length, 2 = Width
# <Kind> can be associated with parts or assemblies.
# <Grain> is usually associated only with parts.

# Parts should provide an association between it's thickness and the Compose variable
# which the shape uses. The syntax to do this is as follows:

#				<Thickness>				VarName

# PartID's between 9991 and 9999 are reserved for UserParts. These parts do not
# exist geometrically, but can be added to the part list of items (cabinets).
# The variables "W", "H" and "D" give their outside dimensions.
# The variable "GQ" specifies the quantity requested.
# The variable "VGC1" specifies the material to be used.

#-----------------------------------------------------------------------------

# ******* Side of cabinet ******

  1     Case Base Left Side             W=W+TW0000[1]
                                        H=H+TH0000[1]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST
		
  2     Case Base Right Side            W=W+TW0000[2]
                                        H=H+TH0000[2]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST2
		
  3     Case Base Side                  W=W+TW0000[3]
                                        H=H+TH0000[3]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST

 11     Case Wall Left Side             W=W+TW0000[11]
                                        H=H+TH0000[11]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST

 12     Case Wall Right Side            W=W+TW0000[12]
                                        H=H+TH0000[12]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST2

 13     Case Wall Side                  W=W+TW0000[13]
                                        H=H+TH0000[13]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST


 21     Case Tall Left Side             W=W+TW0000[21]
                                        H=H+TH0000[21]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST

 22     Case Tall right Side            W=W+TW0000[22]
                                        H=H+TH0000[22]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST2

 23     Case Tall Side                  W=W+TW0000[23]
                                        H=H+TH0000[23]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST

 31     Case Skin Left                  W=W+TW0000[31]
                                        H=H+TH0000[31]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST

 32     Case Skin Right                 W=W+TW0000[32]
                                        H=H+TH0000[32]
		<Kind>							0
		<Grain>							0
		<Thickness>						ST2
# ----------------------------------------------------------------------------

# *********** Panel ************

100     Panel                           W=W+TW0000[100]
                                        H=H+TH0000[100]
		<Kind>			               			0
		<Grain>							0
		<Thickness>						DT1

101     Panel For Cut Corner            W=W+TW0100[1]
                                        H=H+TH0100[1]              
		<Kind>							0
		<Grain>							0
		<Thickness>						CCT

110     Panel For Blind                 W=W+TW0100[10]
                                        H=H+TH0100[10]    
		<Kind>							0
		<Grain>							0
		<Thickness>						BLT

120     Panel For Oven                  W=W+TW0100[20]
                                        H=H+TH0100[20]     
		<Kind>							0
		<Grain>							0
		<Thickness>						OPT1

130     End Front Panel                 W=W+TW0100[30]
                                        H=H+TH0100[30]     
		<Kind>							0
		<Grain>							0
		<Thickness>						PT1

131     End Left Side Panel             W=W+TW0100[31]
                                        H=H+TH0100[31]     
		<Kind>							0
		<Grain>							0
		<Thickness>						PT1

132     End Right Side Panel             W=W+TW0100[32]
                                        H=H+TH0100[32]     
		<Kind>							0
		<Grain>							0
		<Thickness>						PT1

# ----------------------------------------------------------------------------
# ******* Stile of frame *******

200     Frame Stile (Diagonal)          W=W+TW0100[100]
					H=H+TH0100[100]
                <Kind>							0
		<Grain>							1
		<Thickness>						STT
		
201     Frame Left Stile (Diagonal)     W=W+TW0200[1]
					H=H+TH0200[1]
                <Kind>							0
		<Grain>							1
		<Thickness>						STT
		<SubType>						SST

202     Frame Right Stile (Diagonal)    W=W+TW0200[2]
					H=H+TH0200[2]
                <Kind>							0
		<Grain>							1
		<Thickness>						STT
		<SubType>						SST2


210     Frame Stile (Horizontal)        W=W+TW0200[10]
					H=H+TH0200[10]
                <Kind>							0
		<Grain>							2
		<Thickness>						STT

211    	Frame Stile (Vertical)          W=W+TW0200[11]
					H=H+TH0200[11]
                <Kind>							0
		<Grain>							1
		<Thickness>						STT

212    	Frame Center Stile (Vertical)   W=W+TW0200[12]
					H=H+TH0200[12]
                <Kind>							0
		<Grain>							1
		<Thickness>						STT

220    	Side Frame Rail 		W=W+TW0200[20]
					H=H+TH0200[20]
                <Kind>							0
		<Grain>							1
		<Thickness>						ST

221    	Side Frame Stile Front 		W=W+TW0200[21]
					H=H+TH0200[21]
                <Kind>							0
		<Grain>							1
		<Thickness>						ST

222    	Side Frame Stile Back 		W=W+TW0200[22]
					H=H+TH0200[22]
                <Kind>							0
		<Grain>							1
		<Thickness>						ST


# ----------------------------------------------------------------------------

# ******** Floor & Top *********

300     Case Floor                      W=W+TW0200[100]
                                        H=H+TH0200[100]
		<Kind>							0
		<Grain>							0
		<Thickness>						FT

301     Case Top                        W=W+TW0300[1]
                                        H=H+TH0300[1]
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

303     Shelf (Partition)           W=W+CW0301
                                        H=H+CH0301
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

304     Corner Shelf (Partition)    W=W+CW0301
                                        H=H+CH0301
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

305     Corner Shelf (Bottom)       W=W+CW0300
                                        H=H+CH0300
		<Kind>							0
		<Grain>							0
		<Thickness>						FT

306     Corner Shelf (Top)          W=W+CW0301
                                        H=H+CH0301
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

307     Corner Panel                    W=W
                                        H=H
		<Kind>							0
		<Grain>							0
		<Thickness>						PT1

310     Finished Floor                  W=W+TW0300[10]
                                        H=H+TH0300[10]
		<Kind>							0
		<Grain>							0
		<Thickness>						FT
		
# ----------------------------------------------------------------------------

# ************ Back ************

397     Case Back                       W=W+TW0300[97]
                                        H=H+TH0300[97]
# (Middle section)
		<Kind>							0
		<Grain>							0
		<Thickness>						BT

398     Case Back R                     W=W+TW0300[98]
                                        H=H+TH0300[98]
# (Section beside right side)
		<Kind>							0
		<Grain>							0
		<Thickness>						BT

399     Case Back L                     W=W+TW0300[99]
                                        H=H+TH0300[99]
# (Section beside left side)
		<Kind>							0
		<Grain>							0
		<Thickness>						BT

400     Case Back                       W=W+TW0300[100]
                                        H=H+TH0300[100]
		<Kind>							0
		<Grain>							0
		<Thickness>						BT
		
401     Case Back Recess Pipe Chase Side Left   W=W+TW0400[1]
                                                H=H+TH0400[1]
		<Kind>							0
		<Grain>							0
		<Thickness>						RPBT

402     Case Back Recess Pipe Chase Back  W=W+TW0400[2]
                                          H=H+TH0400[2]
		<Kind>							0
		<Grain>							0
		<Thickness>						RPBT

403     Case Back Recess Pipe Chase Side Right  W=W+TW0400[3]
	                                          H=H+TH0400[3]
		<Kind>							0
		<Grain>							0
		<Thickness>						RPBT

405     Cleat                           W=W
                                        H=H
		<Kind>							0
		<Grain>							0
		<Thickness>						UD5


410     Case Diagonal Back              W=W+TW0400[10]
                                        H=H+TH0400[10]
                                        D=D+CD0410
		<Kind>							0
		<Grain>							0
		<Thickness>						BT

411     Case Clipped Diagonal Back      W=W+TW0400[11]
                                        H=H+TH0400[11]
                                        D=D+CD0410
		<Kind>							0
		<Grain>							0
		<Thickness>						CCBT

420     Case Back                       W=W+TW0400[20]
                                        H=H+TH0400[20]
		<Kind>							0
		<Grain>							0
		<Thickness>						BT

421     Case Peninsula Back             W=W+TW0400[21]
                                        H=H+TH0400[21]
		<Kind>							0
		<Grain>							0
		<Thickness>						PBT

422     Case Cneter Back Pen            W=W+TW0400[22]
                                        H=H+TH0400[22]
		<Kind>							0
		<Grain>							0
		<Thickness>						BT

431     Case Left Back For Base End     W=W+TW0400[31]
                                        H=H+TH0400[31]
		<Kind>							0
		<Grain>							0
		<Thickness>						BT

432     Case Right Back For Base End    W=W+TW0400[32]
                                        H=H+TH0400[32]
		<Kind>							0
		<Grain>							0
		<Thickness>						BT
# ----------------------------------------------------------------------------

# ********* Divider ************

500     Divider For Base                W=W+TW0400[100]
                                        H=H+TH0400[100]    
		<Kind>							0
		<Grain>							0
		<Thickness>						DVT

510     Divider                         W=W+TW0500[10]
                                        H=H+TH0500[10]
		<Kind>							0
		<Grain>							0
		<Thickness>						DVT

511     Drawer Partition                W=W+TW0500[11]
                                        H=H+TH0500[11]
		<Kind>							0
		<Grain>							0
		<Thickness>						DVT

520     Divider For Wine Rack                
		<Kind>							0
		<Grain>							0
		<Thickness>						DVT

530	Partition (Vertical)              W=W+TW0500[30]
                                        H=H+TH0500[30]
		<Kind>							0
		<Grain>							0
		<Thickness>						VPT

540	Partition (Horizontal)            W=W+TW0500[40]
                                        H=H+TH0500[40]
		<Kind>							0
		<Grain>							0
		<Thickness>						HPT

531  	Divider For Angle Front           W=W+TW0500[31]
                                        H=H+TH0500[31]
		<Kind>							0
		<Grain>							0
		<Thickness>						STT
# ----------------------------------------------------------------------------

# ********** Shelf **********

600     Ajustable Shelf                 W=W+TW0500[100]
                                        H=H+TH0500[100]                
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

601    	Line Boring Inprint             
		<Kind>							0
		<Grain>							0
		<Thickness>						0

602	Shelf Toe Stop                  W=W
                                        H=TSH
		<Kind>							0
		<Grain>							0
		<Thickness>						TST

603	Heel Grip                  	W=W
                                        H=HGH
		<Kind>							0
		<Grain>							0
		<Thickness>						HGT

606     Corner Ajustable Shelf          W=W
                                        H=H
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT
609    Slanted Shoe Shelf               W=W
                                        H=H
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

610     Fixed Shelf			W=W+TW0600[10]
					H=H+TH0600[10]                                       
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

611     Trim shelf                      W=W
                                        H=H
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

615     Glass Shelf                      W=W
                                        H=H
		<Kind>							0
		<Grain>							0
		<Thickness>						GT

620     Shelf                           
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

630     Shelf                           
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

640     Sliding Shelf                   
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

650     Case Fixed Shelf                
                                        
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

660     Shelf For MicroWave                 
		<Kind>							0
		<Grain>							0
		<Thickness>						SHT

# ----------------------------------------------------------------------------

# ********** Toe Kick **********

700     Case Toe Kick Front             W=W+TW0600[100]
                                        H=H+TH0600[100]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

701     Case Toe Kick Back              W=W+TW0700[1]
                                        H=H+TH0700[1]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

702     Case Toe Kick Side Left         W=W+TW0700[2]
                                        H=H+TH0700[2]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

703     Case Toe Kick Side Right        W=W+TW0700[3]
                                        H=H+TH0700[3]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

705     Case Diagonal Toe Kick          W=W+TW0700[5]
                                        H=H+TH0700[5]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

710     Case Toe Box                    W=W+TW0700[10]
                                        H=H+TH0700[10]
		<Kind>							0
		<Grain>							0
		<Thickness>						D

720     Platform Toe Kick Back          W=W+TW0700[20]
                                        H=H+TH0700[20]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

721     Platform Toe Kick Divider       W=W+TW0700[21]
                                        H=H+TH0700[21]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

722     Platform Toe Kick Top           W=W+TW0700[22]
                                        H=H+TH0700[22]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

723     Platform Toe Kick Front         W=W+TW0700[23]
                                        H=H+TH0700[23]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

724     Platform Toe Kick Left Side     W=W+TW0700[24]
                                        H=H+TH0700[24]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

725     Platform Toe Kick Right Side    W=W+TW0700[25]
                                        H=H+TH0700[25]
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

750     Cabinet Leg
		<Kind>							4
		<Grain>							0
		<SubType>						LEGS
				
# ----------------------------------------------------------------------------

# ********** Cabinet Stretcher/Rail **********

800     Case Top Back Stretcher         W=W+TW0700[100]
                                        H=H+TH0700[100]                                          
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

801     Case Top Front Stretcher        W=W+TW0800[1]
                                        H=H+TH0800[1]                                               
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

802     Case Drawer Front Rail          W=W+TW0800[2]
                                        H=H+TH0800[2]                                        
		<Kind>							0
		<Grain>							0
		<Thickness>						RT

803     Case Sink Front Rail            W=W+TW0800[3]
                                        H=H+TH0800[3]
		<Kind>							0
		<Grain>							0
		<Thickness>						RT

804     Case Center Stile               W=W+TW0800[4]
                                        H=H+TH0800[4]
		<Kind>							0
		<Grain>							0
		<Thickness>						STT

805     Case Sink Back Rail             W=W+TW0800[5]
					H=H+TH0800[5]
		<Kind>							0
		<Grain>							0
		<Thickness>						RT

806     Case Drawer Back Rail           W=W+TW0800[6]
					H=H+TH0800[6]                                        
		<Kind>							0
		<Grain>							0
		<Thickness>						RT

807     Case Center Support             W=W+TW0800[7]
					H=H+TH0800[7]
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

808     Case Left Stretcher             W=W+TW0800[8]
                                        H=H+TH0800[8]                                               
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

809     Case Right Stretcher            W=W+TW0800[9]
                                        H=H+TH0800[9]                                               
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

810     Case Corner Bracket             W=W+TW0800[10]
                                        H=H+TH0800[10]     
		<Kind>							0
		<Grain>							0
		<Thickness>						RT

811     Base Wood                       W=W+TW0800[11]
                                        H=H+TH0800[11]
		<Kind>							0
		<Grain>							0

812     Case Top Front Stretcher L      W=W+TW0800[12]
                                        H=H+TH0800[12]                                               
# (Section beside left side)
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

813     Case Top Front Stretcher R      W=W+TW0800[13]
                                        H=H+TH0800[13]                                               
# (Section beside right side)
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

814     Case Top Front Stretcher        W=W+TW0800[14]
                                        H=H+TH0800[14]                                               
# (Middle section)
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

816     Case Front Rail		        W=W+TW0800[16]
                                        H=H+TH0800[16]     
		<Kind>							0
		<Grain>							1
		<Thickness>						CFRT

818     Case Stretcher        		W=W+TW0800[18]
                                        H=H+TH0800[18]                                               
# (Use in Add Parts Section)
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

819     Case Rail             		W=W+TW0800[19]
					H=H+TH0800[19]
# (Use in Add Parts Section)
		<Kind>							0
		<Grain>							0
		<Thickness>						RT

820     Roll-out Support                W=W+TW0800[20]
                                        H=H+TH0800[20]     
		<Kind>							1
		<Grain>							0

821     Pull-out Support                W=W+TW0800[21]
					H=H+TH0800[21]    
		<Kind>							0
		<Grain>							0
		
822     Pull-out Divider                W=W+TW0800[22]
					H=H+TH0800[22]   
		<Kind>							0
		<Grain>							0
		<Thickness>						DVT
# ----------------------------------------------------------------------------

# ********** Cabinet Nailer **********

850     Case Top Nailer                 W=W+TW0800[50]
					H=H+TH0800[50]
					                                     
		<Kind>							0
		<Grain>							0
		<Thickness>						NT

851     Case Bottom Nailer              W=W+TW0800[51]
					H=H+TH0800[51]                                        
		<Kind>							0
		<Grain>							0
		<Thickness>						NT

852     Case Intermediate Nailer        W=W+TW0800[52]
                                        H=H+TH0800[52]                                        
		<Kind>							0
		<Grain>							0
		<Thickness>						NT

855     Case Vertical Nailer            W=W+TW0800[55]
                                        H=H+TH0800[55]                                        
		<Kind>							0
		<Grain>							0
		<Thickness>						NT

860     Case Nailer                     W=W+TW0800[60]
					H=H+TH0800[60]
# (Use in Add Parts Section)
					                                     
		<Kind>							0
		<Grain>							0
		<Thickness>						NT


870    Valance                          W=W
                                        H=H
                                        D=D

# ----------------------------------------------------------------------------

# ********** Filler **********

900     Filler                          W=W+TW0800[100]
					          H=H+TH0800[100]
		<Kind>							0
		<Grain>							0
		<Thickness>						FILT

910     Filler Back                    
		<Kind>							0
		<Grain>							0
		<Thickness>						FILT

940     Filler Bottom Return                    
		<Kind>							0
		<Grain>							0
		<Thickness>						FT

941     Filler Top Return                    
		<Kind>							0
		<Grain>							0
		<Thickness>						TT

942     Filler Left Side Return                    
		<Kind>							0
		<Grain>							0
		<Thickness>						ST

943     Filler Right Side Return                    
		<Kind>							0
		<Grain>							0
		<Thickness>						ST2

944     Filler Toe Kick                    
		<Kind>							0
		<Grain>							0
		<Thickness>						TKTC

961     Filler Bottom Cap                    
		<Kind>							0
		<Grain>							0
		<Thickness>						FILT

962     Filler Top Cap                    
		<Kind>							0
		<Grain>							0
		<Thickness>						FILT
# ----------------------------------------------------------------------------

# ********** Drawer Box **********

1000    Drawer Box Floor                W=W+CW1000
                                        H=H+CH1000
		<Kind>							0
		<Grain>							0
		<Thickness>						DBT
		
1001    Drawer Box Side                 W=W+CW1001
                                        H=H+CH1001
		<Kind>							0
		<Grain>							0
		<Thickness>						DST
		
1002    Drawer Box Front                W=W+CW1002
                                        H=H+CH1002
		<Kind>							0
		<Grain>							0
		<Thickness>						DFT
		
1003    Drawer Box Back                 W=W+CW1003
                                        H=H+CH1003
		<Kind>							0
		<Grain>							0
		<Thickness>						DBKT
		
1004    Drawer Box Divider             
               	<Kind>							0
		<Grain>							0
		<Thickness>						DVT

# ----------------------------------------------------------------------------

# ********** Door/Drawer Front **********

1100    Door Base Center                
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1101    Door/Drawer Stile                     
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1102    Door/Drawer Top Rail                     
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1103    Door/Drawer Bottom Rail                     
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1104    Door/Drawer Intermediary Rail                     
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1105    Door Base                       
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1
		<SubType>						SDB

1106    Door/Drawer Center Panel                     
		<Kind>							0
		<Grain>							0
		<Thickness>						DT2

1107    Door/Drawer Slab                     
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1108    Door/Drawer MDF                       
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1109    Door/Drawer Mitered Frame                       
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1110    Door Wall Center                
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1115    Door Wall                       
                <Kind>							0
		<Grain>							0
		<Thickness>						DT1
		<SubType>						SDW

1130    Door Mullion                         
		<Kind>							0
		<Grain>							0
		<Thickness>						MT

1220    Door Glass                           
		<Kind>							1
		<Grain>							0
		<Thickness>						GT

1120    Drawer Front Center             
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1

1125    Drawer Front                    
		<Kind>							0
		<Grain>							0
		<Thickness>						DT1
		<SubType>						SDRW

1135    Tambour Door                    
		<Kind>							0
		<Grain>							0

# ----------------------------------------------------------------------------


1200    Pull-U                            
		<Kind>							4
		<Grain>							0
		<Thickness>						PW1
		<SubType>						SPUL

1201    Pull-Knob                            
		<Kind>							4
		<Grain>							0
		<Thickness>						PW1
		<SubType>						SPUL

1205    Lock                            
		<Kind>							4
		<Grain>							0
		
					
1210    Slides Side Part                         
		<Kind>							4
		<Grain>							0
		<SubType>						SDS

1211    Slides Drawer Part    	                      
		<Kind>							4
		<Grain>							0
		<SubType>						SDS

1212    Metabox Drawer Side	      	              
		<Kind>							4
		<Grain>							0

1215    Rear Mounting Socket Left       D=Round(SMD-DWSD1+2.24,3)            
		<Kind>							4
		<Grain>							0

1216    Rear Mounting Socket Right      D=Round(SMD-DWSD1+2.24,3)                      
		<Kind>							4
		<Grain>							0

1220	Glass                   			
			<Kind>	0
			<Grain>	0
			<Thickness>					GT

1221	Mirror                   			
			<Kind>	0
			<Grain>	0
			<Thickness>					GT


1240    Valance                       
		<Kind>							0
		<Grain>							1
		<Thickness>						VALT
		<SubType>						SVE

1250    Hinge                           
		<Kind>							4
		<Grain>							0
		<SubType>						SHG
		<SubType>						HGOP
		<SubType>						HOVLT

1251    Mounting Plate                           
		<Kind>							4
		<Grain>							0
		<SubType>						SHG

1252    Hinge Door Part                           
		<Kind>							4
		<Grain>							0
		<SubType>						SHG

1255    Piano Hinge                           
		<Kind>							4
		<Grain>							0

1260    Edge Trim                           
		<Kind>							1
		<Grain>							0

1261    Solid Edge                           
		<Kind>							1
		<Grain>							0
		<Thickness>						ETT1


1262    Wood edge                          
		<Kind>							0
		<Grain>							1
		<Thickness>						ETT1

1271    Surface Finished                           
		<Kind>							1
		<Grain>							0

1301    Spacer                           
		<Kind>							0
		<Grain>							1
		<Thickness>						ETT4

1302    Cleat Left                           
		<Kind>							0
		<Grain>							1
		<Thickness>						CLTL

1303    Cleat Right                           
		<Kind>							0
		<Grain>							1
		<Thickness>						CLTR

1310	Counter Top/Soffit   
		<Kind>							0
		<Grain>							1

# ----------------------------------------------------------------------------
# ********** Accessories **********


1400    Posts                           
		<Kind>							0
		<Grain>							0

1410    Rod Support                           
		<Kind>							1
		<Grain>							0

1415    Lazy Susan Shaft                           
		<Kind>							4
		<Grain>							0

1420	Lazy Susan             		
		<Kind>							4
		<Grain>							0
		<SubType>						LST

1421    Baskets	                        W=W
                                        H=BH
                                        D=BD

1500    Wire Basket                           
		<Kind>							1
		<Grain>							0

1510    Wine Rack                           
		<Kind>							1
		<Grain>							0

1515    Wine Glass Holder End                           
		<Kind>							0
		<Grain>							0

1516    Wine Glass Holder Middle                           
		<Kind>							0
		<Grain>							0

1517    Wine Glass Holder Top                           
		<Kind>							0
		<Grain>							0

1518    Wine Rack Front Rail                           
		<Kind>							0
		<Grain>							0

1519    Wine Rack Back Rail                           
		<Kind>							0
		<Grain>							0

1520    Plate Rack               
		<Kind>							0
		<Grain>							0

1525    Accessory Top			 W=W+TW1500[25]
                                         H=H+TH1500[25]
		<Kind>							0
		<Grain>							1
		<Thickness>						SRT

1526    Accessory Bottom		 W=W+TW1500[26]
                                         H=H+TH1500[26]
		<Kind>							0
		<Grain>							1
		<Thickness>						SRT

1527    Accessory Center Divider	 W=W+TW1500[27]
                                         H=H+TH1500[27]
		<Kind>							0
		<Grain>							1
		<Thickness>						SRT

1528    Accessory Left Side		 W=W+TW1500[28]
                                         H=H+TH1500[28]
		<Kind>							0
		<Grain>							1
		<Thickness>						SRT

1529    Accessory Right Side		 W=W+TW1500[29]
                                         H=H+TH1500[29]
		<Kind>							0
		<Grain>							1
		<Thickness>						SRT

1530    Accessory Shelf		 W=W+TW1500[30]
                                         H=H+TH1500[30]
		<Kind>							0
		<Grain>							1
		<Thickness>						SRT

1531    Accessory Back			 W=W+TW1500[31]
                                         H=H+TH1500[31]
		<Kind>							0
		<Grain>							1
		<Thickness>						SRBT

1532    Accessory Trim			 W=W+TW1500[32]
                                         H=H+TH1500[32]
		<Kind>							0
		<Grain>							1
		<Thickness>						SRTT

1540    Accessory Cut Board		 W=W+TW1500[40]
                                         H=H+TH1500[40]
		<Kind>							0
		<Grain>							1
		<Thickness>						CBT
# ----------------------------------------------------------------------------
# ********** 3D Object for Items List **********

1230    Molding Wall                       
		<Kind>							0
		<Grain>							1
		<Thickness>						MDF

1600	Counter Top   
		<Kind>							0
		<Grain>							1
		<Thickness>						CTT

1610	Counter Edge                
		<Kind>							1
		<Grain>							2

1620	Backsplash                       
		<Kind>							1
		<Grain>							1
		<Thickness>						BSPLD

1630	Soffit             
		<Kind>							0
		<Grain>							1

1640	Molding Top                  
		<Kind>							0
		<Grain>							1
		<Thickness>						MDF

1650	Molding Bottom
		<Kind>							0
		<Grain>							1
		<Thickness>						MDF

1660	Toe Kick
                <Kind>							0
		<Grain>							1
		<Thickness>						TKT

# ----------------------------------------------------------------------------

# ********** Hardware **********

2001     Upward Bi-fold Tilt-Out Mechanism Top Part
		<Kind>							0
		<Grain>							0

2002     Upward Bi-fold Tilt-Out Mechanism Door Part
		<Kind>							0
		<Grain>							0

2003     Upward Bi-fold Tilt-Out Piano Hinge
		<Kind>							0
		<Grain>							0

2021     Upward Tilt-Out Mechanism Side Part
		<Kind>							0
		<Grain>							0

2022     Upward Tilt-Out Mechanism Door Part
		<Kind>							0
		<Grain>							0

2031     Downward Tilt-Out Mechanism Side Part
		<Kind>							0
		<Grain>							0

2032     Downward Tilt-Out Mechanism Door Part
		<Kind>							0
		<Grain>							0

2041     Elevator Fit Mechanism Side Part
		<Kind>							0
		<Grain>							0

2042     Elevator Fit Mechanism Door Part
		<Kind>							0
		<Grain>							0

# ----------------------------------------------------------------------------

# ********** Molding **********

3101  	Top Molding
		<Kind>							0
		<Grain>							1

3105  	Bottom Molding
		<Kind>							0
		<Grain>							1

3111  	Splash
		<Kind>							0
		<Grain>							1

3121  	Edge
		<Kind>							0
		<Grain>							1	

3141  	Toe Base
		<Kind>							0
		<Grain>							1	

3151  	Soffit
		<Kind>							0
		<Grain>							1	

3161  	Ornament
		<Kind>							0
		<Grain>							1

# ----------------------------------------------------------------------------

# ********** Hood **********

3501  	Hood Angled Side Left
		<Kind>							0
		<Grain>							0

3502  	Hood Angled Side Right
		<Kind>							0
		<Grain>							0

3503  	Hood Angled Front Panel
		<Kind>							0
		<Grain>							0

3504  	Hood Back Panel
		<Kind>							0
		<Grain>							0

3505  	Hood Molding
		<Kind>							0
		<Grain>							0

3506  	Hood Decorative Trim
		<Kind>							0
		<Grain>							0

3507  	Hood Decorative Corner Trim
		<Kind>							0
		<Grain>							0

3509  	Hood Side Left
		<Kind>							0
		<Grain>							0

3510  	Hood Side Right
		<Kind>							0
		<Grain>							0

3511  	Hood Front Panel
		<Kind>							0
		<Grain>							0

# ----------------------------------------------------------------------------

# ********** Closet **********

4210    Rod                             W=W
                                        H=H
                                        D=D

4211    Rod Support                     W=W
                                        H=H
                                        D=D

4301    Hamper Wire Basket              W=W
                                        H=H
                                        D=D

4302    Wire Basket (2)                 W=W
                                        H=H
                                        D=D

4303    Wire Basket (1)                 W=W
                                        H=H
                                        D=D

4304    Tie/Belt Rack                   W=W
                                        H=H
                                        D=D

4305    Hook                            W=W
                                        H=H
                                        D=D

4306    Bracket                         W=W
                                        H=H
                                        D=D

4307    Hanging Rail                    W=W
                                        H=H
                                        D=D
4308    Cantilever Bracket              W=W
                                        H=H
                                        D=D

4309    Folding Bracket                 W=W
                                        H=H
                                        D=D

4310    Wire Shelf                      W=W
                                        H=H
                                        D=D

4311    Support Brace                   W=W
                                        H=H
                                        D=D

4312    Joiner                          W=W
                                        H=H
                                        D=D

4313    Close Mesh Shelf                W=W
                                        H=H
                                        D=D

4314    Double Lip Shelf                W=W
                                        H=H
                                        D=D

4315    Heavy Duty Shelf                W=W
                                        H=H
                                        D=D

4316    Linen Shelf                     W=W
                                        H=H
                                        D=D

4317    Wood Front Shelf                W=W
                                        H=H
                                        D=D

4318    Rod & Shelf Shelf               W=W
                                        H=H
                                        D=D

4319    Total Slide Shelf               W=W
                                        H=H
                                        D=D

4320    Corner Rod & Shelf              W=W
                                        H=H
                                        D=D

4321    Corner Shelf Kit                W=W
                                        H=H
                                        D=D

4322    Corner Total Slide Shelf        W=W
                                        H=H
                                        D=D


# ----------------------------------------------------------------------------

# ******* Add-on Parts ******

9001     Add-on part - 1
		<Kind>							0
		<Grain>							0

9002     Add-on part - 2
		<Kind>							0
		<Grain>							0

9003     Add-on part - 3
		<Kind>							0
		<Grain>							0

9004     Add-on part - 4
		<Kind>							0
		<Grain>							0

9005     Add-on part - 5
		<Kind>							0
		<Grain>							0

9006     Add-on part - 6
		<Kind>							0
		<Grain>							0

9007     Add-on part - 7
		<Kind>							0
		<Grain>							0

9008     Add-on part - 8
		<Kind>							0
		<Grain>							0

9009     Add-on part - 9
		<Kind>							0
		<Grain>							0

9010     Add-on part - 10
		<Kind>							0
		<Grain>							0
		
                
# ----------------------------------------------------------------------------

# ******* User parts ******

9991     User part #1                   W=CWPRT1
                                        H=CHPRT1
                                        D=CDPRT1
                                        GQ=UQ1
                                        VGC1=151

9992     User part #2                   W=CWPRT2
                                        H=CHPRT2
                                        D=CDPRT2
                                        GQ=UQ2
                                        VGC1=152

9993     User part #3                   W=CWPRT3
                                        H=CHPRT3
                                        D=CDPRT3
                                        GQ=UQ3
                                        VGC1=153

9994     User part #4                   W=CWPRT4
                                        H=CHPRT4
                                        D=CDPRT4
                                        GQ=UQ4
                                        VGC1=154

9995     User part #5                   W=CWPRT5
                                        H=CHPRT5
                                        D=CDPRT5
                                        GQ=UQ5
                                        VGC1=155

# ******* Manuf Parts 30000 to 31999 ******

32000   AutoCad Part                    
		<Kind>							3
		<Grain>							0

# ----------------------------------------------------------------------------

# ******* Assemblies ******

:1		Case

:3		Drawer Box

:4		Face Frame

:6		Rollout Box

:16		Base Door Assembly

:17		Base Glass Door Assembly

:18		Wall Door Assembly

:19		Wall Glass Door Assembly

:20		Tall Door Assembly

:21		Tall Glass Door Assembly

:22		Drawer Front Assembly

:25		R/P Finished End Assembly

:30		Door Pull Assembly

:31		Drawer Pull Assembly

:40		Platform Toe Kick

:50		End Panel Filler

:51		Filler

:60		Accessories Assembly

:61		Accessories Box

:63		Door Accessories Assembly

:65		Lazy Susan

:70		Spice Rack Assembly

:100		Door & Hardware Assembly

:122		Drawer Front & Drawer Box Assembly
# ----------------------------------------------------------------------------